/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWFunctionParametersDialog;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.VWFunction;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWFunctionsSelectionPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
IVWToolbarBorderActionListener,
MouseListener {
    protected VWToolbarBorder m_functionsBorder = null;
    protected JList m_availableFunctionsList = null;
    protected JButton m_addButton = null;
    protected JButton m_removeButton = null;
    protected JList m_selectedFunctionsList = null;
    protected VWFunctionParametersDialog m_functionParametersDialog = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWCompoundStepDefinition m_stepDefinition = null;

    public void init(VWAuthPropertyData authPropertyData, VWCompoundStepDefinition stepDefinition) {
        this.m_authPropertyData = authPropertyData;
        this.m_stepDefinition = stepDefinition;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 0.5;
        gbCons.weighty = 1.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getAvailableFunctionsPanel(), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 3;
        gbCons.weightx = 0.0;
        this.add((Component)this.getButtonPanel(), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 1;
        gbCons.weightx = 0.5;
        this.add((Component)this.getSelectedFunctionsPanel(), gbCons);
        this.m_functionParametersDialog = new VWFunctionParametersDialog(this.m_authPropertyData);
        this.reinitialize();
    }

    public void setSelectedStep(VWAuthPropertyData authPropertyData, VWCompoundStepDefinition stepDef) {
        try {
            int instructionCount;
            VWInstructionDefinition[] instructionDefs;
            this.m_authPropertyData = authPropertyData;
            this.m_stepDefinition = stepDef;
            this.reinitialize();
            if (this.m_stepDefinition != null && (instructionDefs = this.m_stepDefinition.getInstructions()) != null && (instructionCount = instructionDefs.length) > 0) {
                DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
                this.m_selectedFunctionsList.removeListSelectionListener(this);
                for (int i = 0; i < instructionCount; ++i) {
                    VWFunction function = this.createFunction(instructionDefs[i]);
                    listModel.addElement(function);
                }
                this.m_selectedFunctionsList.addListSelectionListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize() {
        DefaultListModel listModel;
        if (this.m_availableFunctionsList != null) {
            this.m_availableFunctionsList.removeListSelectionListener(this);
            listModel = (VWSortedListModel)this.m_availableFunctionsList.getModel();
            listModel.removeAllElements();
            String[] functionNames = VWFunctionStrings.getLocalizedStrings();
            int functionCount = functionNames.length;
            if (functionCount > 0) {
                for (int i = 0; i < functionCount; ++i) {
                    listModel.addElement(functionNames[i]);
                }
                ((VWSortedListModel)listModel).sort();
            }
            this.m_availableFunctionsList.addListSelectionListener(this);
        }
        if (this.m_selectedFunctionsList != null) {
            this.m_selectedFunctionsList.removeListSelectionListener(this);
            listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
            listModel.removeAllElements();
            this.m_selectedFunctionsList.addListSelectionListener(this);
        }
    }

    public void showParametersDialog(boolean bShow) {
        this.m_functionParametersDialog.setVisible(bShow);
    }

    public boolean isParamDialogVisible() {
        return this.m_functionParametersDialog.isVisible();
    }

    public void releaseReferences() {
        if (this.m_functionsBorder != null) {
            this.m_functionsBorder.removeToolbarBorderActionNotifier(this);
            this.m_functionsBorder.releaseReferences();
            this.m_functionsBorder = null;
        }
        if (this.m_availableFunctionsList != null) {
            this.m_availableFunctionsList.removeMouseListener(this);
            this.m_availableFunctionsList.removeListSelectionListener(this);
            this.m_availableFunctionsList.removeAll();
            this.m_availableFunctionsList = null;
        }
        if (this.m_addButton != null) {
            this.m_addButton.removeActionListener(this);
            this.m_addButton = null;
        }
        if (this.m_removeButton != null) {
            this.m_removeButton.removeActionListener(this);
            this.m_removeButton = null;
        }
        if (this.m_selectedFunctionsList != null) {
            this.m_selectedFunctionsList.removeMouseListener(this);
            this.m_selectedFunctionsList.removeListSelectionListener(this);
            this.m_selectedFunctionsList.removeAll();
            this.m_selectedFunctionsList = null;
        }
        if (this.m_functionParametersDialog != null) {
            this.m_functionParametersDialog.setVisible(false);
            this.m_functionParametersDialog.removeReferences();
            this.m_functionParametersDialog = null;
        }
        this.m_authPropertyData = null;
        this.m_stepDefinition = null;
        this.removeAll();
    }

    public void valueChanged(ListSelectionEvent event) {
        Object src = event.getSource();
        if (src == this.m_availableFunctionsList) {
            this.onAvailableFunctionsListValueChanged();
        } else if (src == this.m_selectedFunctionsList) {
            this.onSelectedFunctionsListValueChanged(this.isParamDialogVisible());
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_addButton) {
            this.performAddAction();
        } else if (object == this.m_removeButton) {
            this.performRemoveAction();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 1: {
                    this.performUpAction();
                    break;
                }
                case 2: {
                    this.performDownAction();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void mouseClicked(MouseEvent event) {
        int clickCount;
        Object src = event.getSource();
        if (src == this.m_availableFunctionsList && this.m_addButton.isEnabled()) {
            if (event.getClickCount() == 2) {
                this.performAddAction();
            }
        } else if (src == this.m_selectedFunctionsList && ((clickCount = event.getClickCount()) == 1 && this.isParamDialogVisible() || clickCount == 2)) {
            this.onSelectedFunctionsListValueChanged(true);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    protected JPanel getAvailableFunctionsPanel() {
        VWToolbarBorder functionsBorder = new VWToolbarBorder(VWResource.s_availableFunctionsStr, 0x40000000);
        functionsBorder.addToolbarBorderActionNotifier(this);
        JPanel availableFunctionsPanel = functionsBorder.getClientPanel();
        availableFunctionsPanel.setLayout(new BorderLayout());
        this.m_availableFunctionsList = new JList();
        this.m_availableFunctionsList.setName("m_availableFunctionsList_VWFunctionSelectionPanel");
        this.m_availableFunctionsList.setModel(new VWSortedListModel());
        this.m_availableFunctionsList.addMouseListener(this);
        this.m_availableFunctionsList.addListSelectionListener(this);
        availableFunctionsPanel.add((Component)new JScrollPane(this.m_availableFunctionsList), "Center");
        return functionsBorder;
    }

    protected JPanel getButtonPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 10;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(3, 0, 3, 0);
        this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
        this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
        this.m_addButton.setToolTipText(VWResource.s_addFunctionStr);
        this.m_addButton.setName("m_addButton_VWFunctionSelectionPanel");
        this.m_addButton.setEnabled(false);
        this.m_addButton.addActionListener(this);
        buttonsPanel.add((Component)this.m_addButton, gbCons);
        ++gbCons.gridy;
        this.m_removeButton = new JButton(VWImageLoader.createImageIcon("remove.gif"));
        this.m_removeButton.setDisabledIcon(VWImageLoader.createImageIcon("remove_d.gif"));
        this.m_removeButton.setToolTipText(VWResource.s_removeFunctionStr);
        this.m_removeButton.setName("m_removeButton_VWFunctionSelectionPanel");
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addActionListener(this);
        buttonsPanel.add((Component)this.m_removeButton, gbCons);
        return buttonsPanel;
    }

    protected JPanel getSelectedFunctionsPanel() {
        this.m_functionsBorder = new VWToolbarBorder(VWResource.s_selectedFunctionsStr, 3);
        this.m_functionsBorder.addToolbarBorderActionNotifier(this);
        this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        JPanel selectedFunctionsPanel = this.m_functionsBorder.getClientPanel();
        selectedFunctionsPanel.setLayout(new BorderLayout());
        this.m_selectedFunctionsList = new JList();
        this.m_selectedFunctionsList.setName("m_selectedFunctionsList_VWFunctionSelectionPanel");
        this.m_selectedFunctionsList.setModel(new DefaultListModel());
        this.m_selectedFunctionsList.addMouseListener(this);
        this.m_selectedFunctionsList.addListSelectionListener(this);
        selectedFunctionsPanel.add((Component)new JScrollPane(this.m_selectedFunctionsList), "Center");
        return this.m_functionsBorder;
    }

    private void onAvailableFunctionsListValueChanged() {
        this.m_selectedFunctionsList.removeListSelectionListener(this);
        this.m_selectedFunctionsList.clearSelection();
        this.m_selectedFunctionsList.addListSelectionListener(this);
        this.m_addButton.setEnabled(true);
        this.m_removeButton.setEnabled(false);
        this.showParamPanel(false);
    }

    private void onSelectedFunctionsListValueChanged(boolean showParamDlg) {
        int[] indices;
        int count;
        this.m_availableFunctionsList.removeListSelectionListener(this);
        this.m_availableFunctionsList.clearSelection();
        this.m_availableFunctionsList.addListSelectionListener(this);
        this.m_addButton.setEnabled(false);
        this.m_removeButton.setEnabled(true);
        this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
        int listCount = listModel.getSize();
        if (listCount > 0 && (count = (indices = this.m_selectedFunctionsList.getSelectedIndices()).length) == 1) {
            if (listCount > 1) {
                int index = indices[0];
                if (index == 0) {
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 2, 1));
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 1, 2));
                } else if (index == listCount - 1) {
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 1, 1));
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 2, 2));
                } else {
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 1, 1));
                    this.m_functionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_functionsBorder.getClientPanel(), 1, 2));
                }
            }
            this.showParamPanel(showParamDlg);
        }
    }

    private void performAddAction() {
        try {
            Object[] objects = this.m_availableFunctionsList.getSelectedValues();
            int count = objects.length;
            if (count > 0) {
                DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
                for (int i = 0; i < count; ++i) {
                    String functionName = (String)objects[i];
                    VWFunction function = this.createFunction(functionName);
                    listModel.addElement(function);
                }
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performRemoveAction() {
        try {
            int[] indices = this.m_selectedFunctionsList.getSelectedIndices();
            int topIndex = indices[0];
            int count = indices.length;
            if (count > 0) {
                DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
                int listCount = listModel.getSize();
                this.m_selectedFunctionsList.removeListSelectionListener(this);
                for (int i = count - 1; i >= 0; --i) {
                    int index = indices[i];
                    VWFunction function = (VWFunction)listModel.getElementAt(index);
                    VWInstructionDefinition functionInstructionDef = function.getInstructionDefinition();
                    int id = functionInstructionDef.getInstructionId();
                    this.m_stepDefinition.deleteInstruction(id);
                    listModel.removeElement(function);
                }
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                }
                this.m_selectedFunctionsList.addListSelectionListener(this);
                listCount = listModel.getSize();
                if (listCount > 0) {
                    if (topIndex == 0) {
                        this.m_selectedFunctionsList.getSelectionModel().setSelectionInterval(0, 0);
                    } else {
                        this.m_selectedFunctionsList.getSelectionModel().setSelectionInterval(topIndex - 1, topIndex - 1);
                    }
                } else {
                    this.m_removeButton.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.showParamPanel(this.isParamDialogVisible());
    }

    private VWFunction createFunction(VWInstructionDefinition instructionDef) {
        VWFunction function = null;
        String functionName = null;
        int actionType = instructionDef.getAction();
        functionName = VWFunctionStrings.getLocalizedString(actionType);
        if (functionName != null) {
            function = new VWFunction(functionName, instructionDef);
        }
        return function;
    }

    private VWFunction createFunction(String functionName) {
        VWFunction function = null;
        VWInstructionDefinition instructionDef = null;
        if (functionName == null) {
            return null;
        }
        try {
            switch (VWFunctionStrings.getActionType(functionName)) {
                case 0: {
                    instructionDef = this.m_stepDefinition.createAssignInstruction(null);
                    break;
                }
                case 27: {
                    instructionDef = this.m_stepDefinition.createBeginCheckPointInstruction();
                    break;
                }
                case 1: {
                    instructionDef = this.m_stepDefinition.createBeginTimerInstruction("", "", "", null);
                    break;
                }
                case 5: {
                    instructionDef = this.m_stepDefinition.createCallInstruction(null);
                    break;
                }
                case 6: {
                    instructionDef = this.m_stepDefinition.createCreateInstruction("", null);
                    break;
                }
                case 37: {
                    instructionDef = this.m_stepDefinition.createDatabaseExecuteInstruction("", "", new String[0]);
                    break;
                }
                case 7: {
                    instructionDef = this.m_stepDefinition.createDelayInstruction("");
                    break;
                }
                case 8: {
                    instructionDef = this.m_stepDefinition.createEndAllTimersInstruction();
                    break;
                }
                case 28: {
                    instructionDef = this.m_stepDefinition.createEndCheckPointInstruction();
                    break;
                }
                case 9: {
                    instructionDef = this.m_stepDefinition.createEndTimerInstruction("");
                    break;
                }
                case 38: {
                    instructionDef = this.m_stepDefinition.createLogInstruction("", "");
                    break;
                }
                case 13: {
                    instructionDef = this.m_stepDefinition.createResumeTimerInstruction("");
                    break;
                }
                case 14: {
                    instructionDef = this.m_stepDefinition.createReturnInstruction("");
                    break;
                }
                case 29: {
                    instructionDef = this.m_stepDefinition.createRollbackCheckpointInstruction("", null, null);
                    break;
                }
                case 16: {
                    instructionDef = this.m_stepDefinition.createSuspendTimerInstruction("");
                    break;
                }
                case 17: {
                    instructionDef = this.m_stepDefinition.createTerminateBranchInstruction();
                    break;
                }
                case 42: {
                    instructionDef = this.m_stepDefinition.createTerminateProcessInstruction();
                    break;
                }
                case 19: {
                    instructionDef = this.m_stepDefinition.createWFEInstruction("0", "");
                    break;
                }
                case 39: {
                    instructionDef = this.m_stepDefinition.createInvokeInstruction("", "");
                    break;
                }
                case 40: {
                    instructionDef = this.m_stepDefinition.createReceiveInstruction("", "");
                    VWReceiveInstruction receiveInstruction = (VWReceiveInstruction)instructionDef;
                    receiveInstruction.setAuthentication(false);
                    break;
                }
                case 41: {
                    instructionDef = this.m_stepDefinition.createReplyInstruction("", "");
                    VWReplyInstruction replyInstruction = (VWReplyInstruction)instructionDef;
                    replyInstruction.setHasAttachments(true);
                    break;
                }
            }
            function = new VWFunction(functionName, instructionDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return function;
    }

    private void showParamPanel(boolean bEnable) {
        VWFunction function;
        VWInstructionDefinition instructionDef = null;
        String functionName = null;
        int actionType = 0;
        if (bEnable && (function = (VWFunction)this.m_selectedFunctionsList.getSelectedValue()) != null) {
            functionName = function.getName();
            instructionDef = function.getInstructionDefinition();
            actionType = instructionDef.getAction();
        }
        this.m_functionParametersDialog.showParameters(instructionDef, actionType, functionName);
        this.m_functionParametersDialog.setVisible(bEnable);
    }

    private void performUpAction() {
        try {
            VWInstructionDefinition tempInstructionDef;
            int index = this.m_selectedFunctionsList.getSelectedIndex();
            DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
            VWFunction function = (VWFunction)listModel.getElementAt(index);
            VWFunction temp = (VWFunction)listModel.getElementAt(index - 1);
            listModel.setElementAt(function, index - 1);
            listModel.setElementAt(temp, index);
            this.m_selectedFunctionsList.getSelectionModel().setSelectionInterval(index - 1, index - 1);
            VWInstructionDefinition[] instructionDefs = this.m_stepDefinition.getInstructions();
            VWInstructionDefinition instructionDef = instructionDefs[index];
            instructionDefs[index] = tempInstructionDef = instructionDefs[index - 1];
            instructionDefs[index - 1] = instructionDef;
            this.m_stepDefinition.setInstructions(instructionDefs);
            if (this.m_authPropertyData != null) {
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDownAction() {
        try {
            VWInstructionDefinition tempInstructionDef;
            int index = this.m_selectedFunctionsList.getSelectedIndex();
            DefaultListModel listModel = (DefaultListModel)this.m_selectedFunctionsList.getModel();
            VWFunction function = (VWFunction)listModel.getElementAt(index);
            VWFunction temp = (VWFunction)listModel.getElementAt(index + 1);
            listModel.setElementAt(function, index + 1);
            listModel.setElementAt(temp, index);
            this.m_selectedFunctionsList.getSelectionModel().setSelectionInterval(index + 1, index + 1);
            VWInstructionDefinition[] instructionDefs = this.m_stepDefinition.getInstructions();
            VWInstructionDefinition instructionDef = instructionDefs[index];
            instructionDefs[index] = tempInstructionDef = instructionDefs[index + 1];
            instructionDefs[index + 1] = instructionDef;
            this.m_stepDefinition.setInstructions(instructionDefs);
            if (this.m_authPropertyData != null) {
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

